﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Net;
using System.Web;

namespace GetCommand
{
    public class SavePic
    {
        /// <summary>
        /// 在制定的文件下存放图片
        /// </summary>
        /// <param name="context"></param>
        /// <param name="urlpath">图片的路径</param>
        public static string SavePicToDocument(string yearpath,string Mdpath)
        {
            try
            {                
                //创建静态文件夹html下的子文件，即html/2008/1014这种格式，2008表示年，1014表示10月14号这天。即这天产生的静态文件
                string CreatePathYear = HttpContext.Current.Server.MapPath(yearpath).ToString();
                string CreatePathMD = HttpContext.Current.Server.MapPath(Mdpath).ToString();

                //如果以年命名的文件夹没有，则建立以年为文件名的文件
                if (!Directory.Exists(CreatePathYear))
                {
                    Directory.CreateDirectory(CreatePathYear);
                }
                //如果以月日命名的文件夹没有，则建立以为月日文件名的文件
                if (!Directory.Exists(CreatePathMD))
                {
                    Directory.CreateDirectory(CreatePathMD);
                }
                return CreatePathMD;
            }
            catch (Exception ex)
            {
                //logger.Error(ex.Message + ex.StackTrace);//如果存放静态页面文件夹的过程中捕获异常，写入日志文件
                string errorpath =HttpContext.Current.Server.MapPath("/UpLoadImage/ErrorLog/");
                System.IO.StreamWriter sw = new StreamWriter(errorpath, true);
                sw.WriteLine("错误时间：" + System.DateTime.Now.ToString() + "," + "错误原因：" + ex.Message + ex.StackTrace);
                sw.Flush();
                sw.Close();
            }
            return "";
        }

        /// <summary>
        /// 返回虚拟的图片路径
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public static string virtual_path(string path)
        {
            string virtual_pathyear = path + DateTime.Now.ToString("yyyy");
            string virtual_pathMD = path + DateTime.Now.ToString("yyyy") + "/" + DateTime.Now.ToString("MMdd");
            return virtual_pathyear + "#" + virtual_pathMD;
            
        }
    }
}
